----------------------------------------------------------------------------
--                      CLEAN_Address for Custom Applications
--
--                        crt_cln_address_APP.sql
--
--                             Version 1.0
--
--                          December 21, 2008
--
----------------------------------------------------------------------------
--
-- Description : This script creates an additional address table
--               to store other address related information
--
--
----------------------------------------------------------------------------
-- Changes:
--   12/1/2008 Created
----------------------------------------------------------------------------
-- For Support or assistance please contact:
--   Runner Technologies, Inc.  561-395-9322  support@RunnerTechnologies.com
--   www.RunnerTechnologies.com
----------------------------------------------------------------------------
-- Copyright (c) 2006-2008 Runner Technologies, Inc.  All Rights Reserved.
----------------------------------------------------------------------------

prompt ## Additional Address table for storing other address
prompt ##   attributes (CLN_ADDRESS_APP)

create table CLN_ADDRESS_APP (
  ID_NUMBER                   VARCHAR2(100)  NOT NULL
 ,FROM_TABLE                  VARCHAR2(30)   NOT NULL
 ,ADDRESS_TYPE                VARCHAR2(100)
 ,EFFECTIVE_DATE              DATE
 -- Additional address columns
 ,CARRIER_ROUTE               VARCHAR2(4)
 ,DELIVERY_POINT              VARCHAR2(2)
 ,CHECK_DIGIT                 VARCHAR2(1)
 ,POSTNET_BARCODE             VARCHAR2(20)
 ,LAST_LINE                   VARCHAR2(100)
 ,ADDRESS_VERIFIED_DATE       DATE
 ,ADDRESS_ERROR_CODE          VARCHAR2(30)
 ,SUGGESTION_LIST             VARCHAR2(2000)
 ,LATITUDE                    NUMBER
 ,LONGITUDE                   NUMBER
 ,PHONE_DISTANCE              NUMBER
 ,PHONE_SUGGESTED_AREA_CODE   VARCHAR2(3)
 ,PHONE_ERROR_CODE            VARCHAR2(30)
 ,EMAIL_ERROR_CODE            VARCHAR2(30)
 ,NAME_ERROR_CODE             VARCHAR2(30)
 );

comment on column CLN_ADDRESS_APP.ID_NUMBER                 IS 'ID from Application table. ie) Person_ID';
comment on column CLN_ADDRESS_APP.ADDRESS_TYPE              IS 'Address Type from Application table.';
comment on column CLN_ADDRESS_APP.EFFECTIVE_DATE            IS 'Effective Date from Application table.';
comment on column CLN_ADDRESS_APP.FROM_TABLE                IS 'Table where this record is from: ie) APP_ADDRESS';
comment on column CLN_ADDRESS_APP.CARRIER_ROUTE             IS 'CLEAN_Address: USPS Carrier Route';
comment on column CLN_ADDRESS_APP.DELIVERY_POINT            IS 'CLEAN_Address: USPS Delivery Point';
comment on column CLN_ADDRESS_APP.CHECK_DIGIT               IS 'CLEAN_Address: USPS Check Digit';
comment on column CLN_ADDRESS_APP.POSTNET_BARCODE           IS 'CLEAN_Address: Postnet barcode numbers';
comment on column CLN_ADDRESS_APP.LAST_LINE                 IS 'CLEAN_Address: Last Address line for international addresses';
comment on column CLN_ADDRESS_APP.ADDRESS_VERIFIED_DATE     IS 'CLEAN_Address: Date the address was verified';
comment on column CLN_ADDRESS_APP.ADDRESS_ERROR_CODE        IS 'CLEAN_Address: Error Code for the address';

comment on column CLN_ADDRESS_APP.PHONE_DISTANCE            IS 'CLEAN_Address: Distance from the Phone to the ZIP Code';
comment on column CLN_ADDRESS_APP.PHONE_SUGGESTED_AREA_CODE IS 'CLEAN_Address: Suggested Area code for the phone number';
comment on column CLN_ADDRESS_APP.PHONE_ERROR_CODE          IS 'CLEAN_Address: Error Code for the telephone number checking';
comment on column CLN_ADDRESS_APP.EMAIL_ERROR_CODE          IS 'CLEAN_Address: Error Code for the email validation';
comment on column CLN_ADDRESS_APP.NAME_ERROR_CODE           IS 'CLEAN_Address: Error Code for the name standardization';

--
-- CLNADDRPS_PKEY  (Index) 
--
CREATE UNIQUE INDEX CLNADDRAPP_PKEY ON CLN_ADDRESS_APP (ID_NUMBER, FROM_TABLE, Address_Type, Effective_Date);

