PROCEDURE Verify_Address IS
  -- Perform address standardization and verification with CLEAN_Address()
  -- NOTE: This procedure should be fired on WHEN-VALIDATE-ITEM on all address fields
  l_address_rec          CLEAN_Address.ADDRESS_REC;
BEGIN
  -- Assign the input data to the address record
  l_address_rec.company       := :ADDR.company;
  l_address_rec.address       := :ADDR.street_address;
  l_address_rec.suite         := :ADDR.suite_apt;
  l_address_rec.city          := :ADDR.city;
  l_address_rec.state         := :ADDR.state;
  l_address_rec.postal_code   := :ADDR.zipcode;
  
  -- Call CLEAN_Address to Verify the address
  CLEAN_Address.Verify( l_address_rec );
  
  -- Retrieve the output from the verified address record
  :ADDR.company             := l_address_rec.company;
  :ADDR.street_address      := l_address_rec.address;
  :ADDR.suite_apt           := l_address_rec.suite;
  :ADDR.city                := l_address_rec.city;
  :ADDR.state               := l_address_rec.state;
  :ADDR.postal_code         := l_address_rec.postal_code;
  :ADDR.zip_plus4           := l_address_rec.postal_code_extended;
  :ADDR.carrier_route       := l_address_rec.carrier_route;
  :ADDR.delivery_point      := l_address_rec.delivery_point;
  :ADDR.check_digit         := l_address_rec.check_digit;
  :ADDR.county_name         := l_address_rec.county_name;
  :ADDR.address_error_code  := l_address_rec.error_code;
  :ADDR.address_status_code := l_address_rec.status_code;
END Verify_Address;
