PROCEDURE Check_Email IS
  -- Parse and/or Check the Email address
  -- NOTE: This procedure should be fired on WHEN-VALIDATE-ITEM on the email field
  email			CLEAN_Address.Email_Rec;
	fv_return_code         VARCHAR2(10);
  fv_return_description  VARCHAR2(500);
BEGIN
  -- Only Verify if the trigger item is the same as the cursor item
  -- (ie. don't fire more than once for one update)
  if :system.trigger_item != :system.cursor_item then
    return;
  end if;

  -- leave if we don't have data
  if :ADDR.email_address IS NULL then
  	:ADDR.email_status_code := NULL;
  	return;
  end if;

  -- initialize the email record
 	email.email_address := :ADDR.email_address;

	-- Parse the email and validate the domain
 	CLEAN_Address.Email_Check_Silent(
    											 email
                          ,fv_return_code
                          ,fv_return_description
                          );
  if fv_return_code IS NOT NULL then
	 	WARNING(fv_return_description);
	  return;
  end if;

 	-- Display the email status
	:ADDR.email_status_code := NULL;

 	-- Display any email status error  	
	if email.Email_Status_Code IS NOT NULL then
    -- Display the email status
 	  :ADDR.email_status_code := email.email_status_code||'-'||cln$lookup.Get_Email_Status(email.Email_Status_Code);
  	WARNING('Email Address Error: '
  	         ||chr(10)||'Status: '||cln$lookup.Get_Email_Status(email.Email_Status_Code)
  	         );
	end if;
		
END;
