/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coordinator;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.tx.Protocol;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.tx.common.Identifier;
import com.sun.xml.ws.tx.common.RegistrantIdentifier;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.RegistrationManager;
import com.sun.xml.ws.tx.webservice.member.coord.RegisterType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.ws.EndpointReference;

public abstract class Registrant {
    private RegisterType registerRequest = null;
    private final Coordinator parent;
    private final Protocol protocol;
    private EndpointReference coordinatorProtocolService = null;
    private static long nextId = 1L;
    private final RegistrantIdentifier id = new RegistrantIdentifier(Long.toString(nextId++));
    private static TxLogger logger = TxLogger.getCoordLogger(Registrant.class);
    private Boolean registrationCompleted = true;
    private Semaphore registrationCompletedGate;
    protected static final Map<String, Registrant> outstandingRegistrants = new HashMap<String, Registrant>();
    private boolean remoteCPS = false;

    public Registrant(@NotNull Coordinator parent, @NotNull RegisterType registerRequest) {
        this(parent, registerRequest.getProtocolIdentifier());
        this.registerRequest = registerRequest;
    }

    protected Registrant(Coordinator parent, String protocolId) {
        this(parent, Protocol.getProtocol(protocolId));
    }

    protected Registrant(@NotNull Coordinator parent, @NotNull Protocol protocol) {
        this.parent = parent;
        this.protocol = protocol;
        if (parent.isSubordinate()) {
            outstandingRegistrants.put(this.getIdValue(), this);
            this.registrationCompleted = false;
            this.registrationCompletedGate = new Semaphore(0);
        } else if (this.registerRequest == null) {
            this.setParticpantProtocolService(this.getLocalParticipantProtocolService());
        }
    }

    @NotNull
    private String getProtocolIdentifier() {
        switch (this.protocol) {
            case COMPLETION: {
                return Protocol.COMPLETION.getUri();
            }
            case DURABLE: {
                return Protocol.DURABLE.getUri();
            }
            case VOLATILE: {
                return Protocol.VOLATILE.getUri();
            }
        }
        return Protocol.UNKNOWN.getUri();
    }

    public void setParticpantProtocolService(@NotNull EndpointReference pps) {
        if (this.registerRequest == null) {
            this.registerRequest = new RegisterType();
        }
        this.registerRequest.setProtocolIdentifier(this.getProtocolIdentifier());
        this.registerRequest.setParticipantProtocolService((MemberSubmissionEndpointReference)pps);
    }

    @NotNull
    public EndpointReference getParticipantProtocolService() {
        return this.registerRequest == null ? this.getLocalParticipantProtocolService() : this.registerRequest.getParticipantProtocolService();
    }

    @Nullable
    public RegisterType getRegisterRequest() {
        return this.registerRequest;
    }

    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public Coordinator getCoordinator() {
        return this.parent;
    }

    @NotNull
    public synchronized EndpointReference getCoordinatorProtocolService() {
        return this.coordinatorProtocolService;
    }

    public synchronized void setCoordinatorProtocolService(@NotNull EndpointReference cps) {
        this.coordinatorProtocolService = cps;
        this.setRegistrationCompleted(true);
    }

    public void register() {
        RegistrationManager.getInstance().register(this.parent, this);
    }

    @NotNull
    public Identifier getId() {
        return this.id;
    }

    @NotNull
    public String getIdValue() {
        return this.id.getValue();
    }

    @Nullable
    public static Registrant getOutstandingRegistrant(String id) {
        return outstandingRegistrants.get(id);
    }

    @Nullable
    public static Registrant removeOutstandingRegistrant(String id) {
        return outstandingRegistrants.remove(id);
    }

    public void setRemoteCPS(boolean value) {
        this.remoteCPS = value;
    }

    public boolean isRemoteCPS() {
        return this.remoteCPS;
    }

    public boolean isRegistrationCompleted() {
        return this.registrationCompleted;
    }

    public synchronized void setRegistrationCompleted(boolean value) {
        this.registrationCompleted = value;
        if (this.isRemoteCPS()) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("setRegistrationCompleted(" + value + ")", "semaphore has " + this.registrationCompletedGate.availablePermits() + " permits.");
            }
            if (value) {
                assert (this.registrationCompletedGate.availablePermits() <= 0);
                this.registrationCompletedGate.release();
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("setRegistrationCompleted(" + value + ")", "released a permit, semaphore now has " + this.registrationCompletedGate.availablePermits() + " permits.");
                }
            }
        }
    }

    public boolean waitForRegistrationResponse() {
        try {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("waitForRegistrationResponse", "semaphore should have 0 permits. actual available permits: " + this.registrationCompletedGate.availablePermits());
                assert (this.registrationCompletedGate.availablePermits() <= 0);
                logger.finest("waitForRegistrationResponse", "Waiting for registration response.  Calling tryAcquire()...");
            }
            return !this.registrationCompletedGate.tryAcquire(1, 40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public abstract EndpointReference getLocalParticipantProtocolService();

    public abstract void forget();
}

