/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMX509Data
extends DOMStructure
implements X509Data {
    private final List content;
    private CertificateFactory cf;

    public DOMX509Data(List list) {
        if (list == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList arrayList = new ArrayList(list);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof String) {
                new X500Principal((String)e);
                continue;
            }
            if (e instanceof byte[] || e instanceof X509Certificate || e instanceof X509CRL || e instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid X509Data type");
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public DOMX509Data(Element element) throws MarshalException {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("X509Certificate")) {
                arrayList.add(this.unmarshalX509Certificate(element2));
                continue;
            }
            if (string2.equals("X509IssuerSerial")) {
                arrayList.add(new DOMX509IssuerSerial(element2));
                continue;
            }
            if (string2.equals("X509SubjectName")) {
                arrayList.add(element2.getFirstChild().getNodeValue());
                continue;
            }
            if (string2.equals("X509SKI")) {
                try {
                    arrayList.add(Base64.decode(element2));
                    continue;
                }
                catch (Base64DecodingException base64DecodingException) {
                    throw new MarshalException("cannot decode X509SKI", base64DecodingException);
                }
            }
            if (string2.equals("X509CRL")) {
                arrayList.add(this.unmarshalX509CRL(element2));
                continue;
            }
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(element2));
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public List getContent() {
        return this.content;
    }

    public void marshal(Node node, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "X509Data", "http://www.w3.org/2000/09/xmldsig#", string2);
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.content.get(i);
            if (e instanceof X509Certificate) {
                this.marshalCert((X509Certificate)e, element, document, string2);
                continue;
            }
            if (e instanceof XMLStructure) {
                if (e instanceof X509IssuerSerial) {
                    ((DOMX509IssuerSerial)e).marshal(element, string2, dOMCryptoContext);
                    continue;
                }
                javax.xml.crypto.dom.DOMStructure dOMStructure = (javax.xml.crypto.dom.DOMStructure)e;
                DOMUtils.appendChild(element, dOMStructure.getNode());
                continue;
            }
            if (e instanceof byte[]) {
                this.marshalSKI((byte[])e, element, document, string2);
                continue;
            }
            if (e instanceof String) {
                this.marshalSubjectName((String)e, element, document, string2);
                continue;
            }
            if (!(e instanceof X509CRL)) continue;
            this.marshalCRL((X509CRL)e, element, document, string2);
        }
        node.appendChild(element);
    }

    private void marshalSKI(byte[] byArray, Node node, Document document, String string2) {
        Element element = DOMUtils.createElement(document, "X509SKI", "http://www.w3.org/2000/09/xmldsig#", string2);
        element.appendChild(document.createTextNode(Base64.encode(byArray)));
        node.appendChild(element);
    }

    private void marshalSubjectName(String string2, Node node, Document document, String string3) {
        Element element = DOMUtils.createElement(document, "X509SubjectName", "http://www.w3.org/2000/09/xmldsig#", string3);
        element.appendChild(document.createTextNode(string2));
        node.appendChild(element);
    }

    private void marshalCert(X509Certificate x509Certificate, Node node, Document document, String string2) throws MarshalException {
        Element element = DOMUtils.createElement(document, "X509Certificate", "http://www.w3.org/2000/09/xmldsig#", string2);
        try {
            element.appendChild(document.createTextNode(Base64.encode(x509Certificate.getEncoded())));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new MarshalException("Error encoding X509Certificate", certificateEncodingException);
        }
        node.appendChild(element);
    }

    private void marshalCRL(X509CRL x509CRL, Node node, Document document, String string2) throws MarshalException {
        Element element = DOMUtils.createElement(document, "X509CRL", "http://www.w3.org/2000/09/xmldsig#", string2);
        try {
            element.appendChild(document.createTextNode(Base64.encode(x509CRL.getEncoded())));
        }
        catch (CRLException cRLException) {
            throw new MarshalException("Error encoding X509CRL", cRLException);
        }
        node.appendChild(element);
    }

    private X509Certificate unmarshalX509Certificate(Element element) throws MarshalException {
        try {
            ByteArrayInputStream byteArrayInputStream = this.unmarshalBase64Binary(element);
            return (X509Certificate)this.cf.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new MarshalException("Cannot create X509Certificate", certificateException);
        }
    }

    private X509CRL unmarshalX509CRL(Element element) throws MarshalException {
        try {
            ByteArrayInputStream byteArrayInputStream = this.unmarshalBase64Binary(element);
            return (X509CRL)this.cf.generateCRL(byteArrayInputStream);
        }
        catch (CRLException cRLException) {
            throw new MarshalException("Cannot create X509CRL", cRLException);
        }
    }

    private ByteArrayInputStream unmarshalBase64Binary(Element element) throws MarshalException {
        try {
            if (this.cf == null) {
                this.cf = CertificateFactory.getInstance("X.509");
            }
            return new ByteArrayInputStream(Base64.decode(element));
        }
        catch (CertificateException certificateException) {
            throw new MarshalException("Cannot create CertificateFactory", certificateException);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new MarshalException("Cannot decode Base64-encoded val", base64DecodingException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509Data)) {
            return false;
        }
        X509Data x509Data = (X509Data)object;
        List list = x509Data.getContent();
        int n = this.content.size();
        if (n != list.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.content.get(i);
            Object e2 = list.get(i);
            if (!(e instanceof byte[] ? !(e2 instanceof byte[]) || !Arrays.equals((byte[])e, (byte[])e2) : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }
}

