/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.sax;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SimpleEntityResolver
implements EntityResolver {
    private Map publicIds_ = new HashMap();
    private Map systemIds_ = new HashMap();
    private List relativeSystemIds_ = new ArrayList();

    public SimpleEntityResolver() {
    }

    public SimpleEntityResolver(String string2, String string3) {
        this._init(new String[][]{{string2, string3}}, null);
    }

    public SimpleEntityResolver(String[][] stringArray) {
        this._init(stringArray, null);
    }

    public SimpleEntityResolver(String[][] stringArray, String[][] stringArray2) {
        this._init(stringArray, stringArray2);
    }

    private void _init(String[][] stringArray, String[][] stringArray2) {
        if (stringArray != null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n][0];
                this.addSystemId(string2, stringArray[n][1]);
                ++n;
            }
        }
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                this.addPublicId(stringArray2[n][0], stringArray2[n][1]);
                ++n;
            }
        }
    }

    public void addSystemId(String string2, String string3) {
        this.systemIds_.put(string2, string3);
        this.relativeSystemIds_.add(string2);
    }

    public void addPublicId(String string2, String string3) {
        this.publicIds_.put(string2, string3);
    }

    public InputSource resolveEntity(String string2, String string3) {
        if (string3 != null && this._isExist(string3)) {
            return new InputSource(string3);
        }
        if (string2 != null) {
            String string4 = (String)this.publicIds_.get(string2);
            if (string4 != null) {
                return new InputSource(string4);
            }
            return null;
        }
        if (string3 != null) {
            String string5 = this._getURIBySystemId(string3);
            if (string5 != null) {
                return new InputSource(string5);
            }
            return new InputSource(string3);
        }
        return null;
    }

    private boolean _isExist(String string2) {
        try {
            URL uRL = new URL(string2);
            if ("file".equals(uRL.getProtocol())) {
                InputStream inputStream = uRL.openStream();
                inputStream.close();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String _getURIBySystemId(String string2) {
        String string3 = (String)this.systemIds_.get(string2);
        if (string3 != null) {
            return string3;
        }
        int n = this.relativeSystemIds_.size();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)this.relativeSystemIds_.get(n2);
            if (string2.endsWith(string4)) {
                return (String)this.systemIds_.get(string4);
            }
            ++n2;
        }
        return null;
    }
}

