/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.KerberosToken,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private String tokenType = null;
    private String id = null;
    private boolean reqDK = false;
    private boolean isServer = false;
    private HashSet<String> referenceType = null;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private static QName itQname;
    private String includeToken;

    public KerberosToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        this.referenceType = new HashSet();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public Set getTokenRefernceType() {
        this.populate();
        return this.referenceType;
    }

    public void addTokenReferenceType(String tokenRefType) {
        this.referenceType.add(tokenRefType);
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        this.includeToken = type;
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(itQname) != null) {
                this.includeToken = this.getAttributeValue(itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isTokenReferenceType(assertion, this.spVersion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isKerberosTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart().intern();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.reqDK = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "KerberosToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

