package clnaddr.ws;

/**
 * <p>Title: Address check  object</p>
 * <p>Description: Java JNI call the Com object of the Melissadata Com</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Resource free</p>
 * @author Tri, Tran Huu
 * @version 1.0
 */

public class NameClient {
  private static NameClient nameObj;

  public static NameClient getInstance() {
    if (nameObj == null) {
      nameObj = new NameClient();
    }
    return nameObj;
  }
  /**
   * Get a NameObject instance
   * @param flag boolean init com if flag is true
   * @return NameObj
   */
  public static NameClient getInstance(boolean flag) {
    if (nameObj == null) {
      nameObj = new NameClient();
    }
    if(flag){
      nameObj.regsrvComNameObj();
      nameObj.comInitialize();
    }
    return nameObj;
  }

  /**
   * register name obj
   * Returns a value greater than 32 if successful,
   * or an error value that is less than or equal to 32 otherwise.
   * @return int
   */
  public native long regsrvComNameObj();

  /**
   * Un register name object
   * Returns a value greater than 32 if successful,
   * or an error value that is less than or equal to 32 otherwise.
   * @return int
   */
  public native long unRegsrvComNameObj();

  /**
   * Initializes the COM library
   * @return null if init success else return the error message
   */
  public native String comInitialize();

  /**
   * Uninitializes the COM library
   */
  public native void comUninitialize();

  /**
   * Set melissadata license
   * @param license
   * @return
   */
  public native boolean setLicenseString(String license);

  /**
   * Here is where we call the Initialize method
   * You must pass the path to the MP4fname.dat file
   * -1 Not Initialized
   * 0 Initialized
   * 1 Invalid Path
   * 2 Unable to open data file
   * @return 0 or !=0, 0 is successful
   */
  public native int initialize(String pathFile);

  /**
   * If Error - Use GetInitializeErrorString() method to get a error code
   * @return a error code
   */
  public native String getInitializeErrorString();

  /**
   * Call GetDatabaseDate method to get database date
   * @return database date
   */
  public native String getDatabaseDate();

  /**
   * Get a build number
   * @return a build number
   */
  public native String getBuildNumber();

  /**
   * Set gender property base on first name
   * @param FirstName String
   * @return boolean
   */
  public native boolean genderize(String FirstName);
  /**
   * Parse a full name
   * @param fullName
   * @return true if successful else return false
   */
  public native boolean parseName(String fullName);

  /**
   * We call the GetStatusCode method to discover or problem
   * @return a status code
   */
  public native String getStatusCode();

  /**
   * Get a prefix of the full name
   * @return a prefix
   */
  public native String getPrefix();

  /**
   * Get first name
   * @return a first name
   */
  public native String getFirstName();

  /**
   * Get a middle name
   * @return a middle name
   */
  public native String getMiddleName();

  /**
   * Get a last name
   * @return a last name
   */
  public native String getLastName();

  /**
   * Get a suffix of the full name
   * @return a suffix
   */
  public native String getSuffix();

  /**
   * Get a gender of the full name
   * @return a gender
   */
  public native String getGender();

  static {
    System.loadLibrary("jNameObj");
  }

}
