/*
 * VerifyAddress.java
 *
 * Created on May 10, 2011, 11:38 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package clnaddr.servlets;

/* Generic java stuff */
import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

//JAXP
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

//DOM
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/* Found in webservices-api.jar */
import java.net.URL;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;

/* RTI web services components found in clnaddr-ws-api.jar*/
import clnaddr.ws.CLNBatchSoap;
import clnaddr.ws.CLNBatch;
import clnaddr.ws.Authentication;
import clnaddr.ws.Parameters;
import clnaddr.ws.CountryReturnType;
import clnaddr.ws.PreferredLanguageType;
import clnaddr.ws.AddressIn;
import clnaddr.ws.ArrayOfAddressIn;
import clnaddr.ws.ArrayOfAddressOut;
import clnaddr.ws.CLNVerify;
import clnaddr.ws.AddressOut;
import clnaddr.ws.Address;

public class VerifyAddress extends HttpServlet {
    
        private String          hostName;
        private String          hostPort;   
        private String          SERVICE_TARGET_NAMESPACE;   
        private String          SERVICE_NAME; 		
        private URL             url;                                
        private QName           qname; 
	private CLNBatch        service;
	private CLNBatchSoap    port;  
        private BindingProvider bp;
        private Properties      properties;
        
	public void init(ServletConfig config) throws ServletException {	
            
		super.init(config);
                try {
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream("WEB-INF/clnaddr.properties");  
                    properties = new Properties();  
                    String pathToPropertiesFile = config.getServletContext().getRealPath("")+"/WEB-INF/clnaddr.properties";
                    properties.load(new FileInputStream(pathToPropertiesFile));                     
                    hostName = properties.getProperty("clnaddrws.serverHost");
                    hostPort = properties.getProperty("clnaddrws.serverPort");
                } catch (IOException e) {
                    e.printStackTrace();
                }                
  
    	        SERVICE_TARGET_NAMESPACE = "http://webservice.clean-address.com/CLNVerify/";   
    	        SERVICE_NAME             = "CLNBatch"; 		
                url                      = getClass().getResource("/clnaddr/ws/CLEAN_Address.wsdl");   
		qname                    = new QName(SERVICE_TARGET_NAMESPACE, SERVICE_NAME);  
		/*
		 * 1. Create service, and port objects
		 */ 
                try{
		  service = new CLNBatch(url, qname);
                } catch (Exception e){
                    e.printStackTrace();
                }

                try {
		  port    = service.getCLNBatchSoap(); 
                } catch (Exception e) {
                  e.printStackTrace();
                }
               
		/*
		 * 2. Instantiate service, and port objects using runtime
		 *    parameters
		 */
		try {
			// Specify port at runtime
			bp = (BindingProvider) port;
			// Set runtime connection parameters
			bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,"http://"+hostName+":"+hostPort+ "/CLNVerify");                                             
		} catch (Exception e) {
			e.printStackTrace();// Perform error logging and shutdown operations
		}   

                try{
                    testConnection();
                } catch (Exception e){
                    e.printStackTrace();// Log the error and shutdown
                }
	}
 
	public void destroy() {
 
	}
          
	public void doGet(HttpServletRequest request,HttpServletResponse response) throws IOException, ServletException {
		doPost(request,response);
	}
        
	public void doPost(HttpServletRequest request,HttpServletResponse response) throws IOException, ServletException {
                  
                //Read AJAX XML request document
                java.util.Enumeration enuParams = request.getParameterNames();
                String sParamName = (String) enuParams.nextElement();

                //DocumentBuilderFactory is configured to handle validation and namespaces
                DocumentBuilderFactory dbfBuilderFactory = DocumentBuilderFactory.newInstance();
                Address address = new Address();

                try{
                    //DocumentBuilder is retrieved from the factory
                    DocumentBuilder dbBuilder = dbfBuilderFactory.newDocumentBuilder();
                    Document docXML = dbBuilder.parse(new InputSource(new StringReader(sParamName)));
                    docXML.getDocumentElement ().normalize ();
                    NodeList nlCoins = docXML.getElementsByTagName("address");
                    Node nodeCoins;
                    Element elLists;

                    int iRow=0;
                    nodeCoins = nlCoins.item(iRow);
                    elLists = (Element)nodeCoins;
                    //Parse XML request document using DOM
                    address.setAddressLine1(nullToString(NodeValue(elLists, "address1")));
                    address.setAddressLine2(nullToString(NodeValue(elLists, "address2")));
                    address.setAddressLine3(nullToString(NodeValue(elLists, "address3")));
                    address.setCity(nullToString(NodeValue(elLists, "city")));
                    address.setState(nullToString(NodeValue(elLists, "state")));
                    address.setZip9(nullToString(NodeValue(elLists, "postalcode")));
                    address.setCountyName(nullToString(NodeValue(elLists, "county"))); 
                    address.setCountryCode(nullToString(NodeValue(elLists, "country")));  
                } catch (Exception e){
                  address.statusCode="-1";;
                }
                
                // Perform web service call to CLEAN_Address web service server
                try{
                  address =  clnVerifyAddress(address);
                } catch (Exception e)    {
                  address.statusCode="-1";
                }
                
                 /* Generate and return response object */ 
                StringBuffer sb = new StringBuffer(); 
                sb.append("<address>");
                sb.append("<address1>"+address.getAddressLine1()+"</address1>");
                sb.append("<address2>"+address.getAddressLine2()+"</address2>");
                sb.append("<address3>"+address.getAddressLine3()+"</address3>");
                sb.append("<city>"+address.getCity()+"</city>");
                sb.append("<state>"+address.getState()+"</state>");
                sb.append("<postalcode>"+address.getZip9()+"</postalcode>");
                sb.append("<county>"+address.getCountyName()+"</county>");
                sb.append("<countrycode>"+address.getCountryCode()+"</countrycode>");
                //TODO: Remove status code after testing
                sb.append("<statuscode>"+address.statusCode+"</statuscode>");
                sb.append("<dpverrorcode>"+address.errorCode+"</dpverrorcode>");
                sb.append("<suggestionlist>"+address.errorString+"</suggestionlist>");                
                sb.append("</address>");                                                
                response.setContentType("text/xml");
                response.setHeader("Cache-Control","no-cache");
                response.getWriter().write(sb.toString());
                
	}

        
        public Address clnVerifyAddress(Address _address){

                /** 
                 *
                 * Ideally, customer ID, password and department ID will be sent via 
                 * the client interface in the XML request document. Defaulting for 
                 * now.
                 *
                 */
            
		long   customerID               = 1;
		String password                 = "password";                
		long   departmentID             = 1;
                
		/*
		 * 3. Set authentication credentials
		 * 
		 */
		Authentication authentication = new Authentication();
		try {
			authentication.setCustomerID(customerID);
		} catch (Exception e) {
			;// Do something
		}

		try {
			authentication.setDepartmentID(departmentID);
		} catch (Exception e) {
			;// Do something
		}  
                authentication.setPassword(password);

		/*
		 * 4. Set address verification parameters
		 * 
		 */
		Parameters parameters = new Parameters();
		parameters.setVerifyAddress(true);
		parameters.setGeoCodeAddress(true);
		parameters.setCheckTelephone(true);
		parameters.setParseName(true);
		parameters.setParseEmail(true);
		parameters.setDNSCheckEmail(false);
		parameters.setUseGenericAddressLines(true);
		parameters.setGenericAddressLines(3);
		parameters.setFullNameInAddress(true);
		parameters.setCompanyNameInAddress(false);
		parameters.setCountryReturnType(CountryReturnType.fromValue("ISO_3"));
		parameters.setPreferredLanguage(PreferredLanguageType.fromValue("DEFAULT"));
		parameters.setErrorSuggestCount(10);
		parameters.setVerboseSuggestList(true);
		parameters.setMaxCityLength(30);
		parameters.setMaxProvinceLength(30);
		parameters.setMaxAddressLineLength(40);
		parameters.setExpandStreetSuffix(false);
		parameters.setExpandSingleDirectional(false);
		parameters.setExpandDoubleDirectional(false);
		parameters.setSuiteLineBeforeStreet(false);
		parameters.setAppendSuiteToStreet(true);
		parameters.setOutputAddressWithCompanyNameAttention(false);
		parameters.setAlwaysStandardize(true);
		parameters.setAlwaysUpperCase(false);
		parameters.setBasicAddressSearch(false);
		parameters.setPhoneNumberOutputFormat("");  

		/*
		 * 5. Create address object to be verified
		 * 
		 */
		AddressIn addressIn = new AddressIn();
		addressIn.setAddressLine1(_address.getAddressLine1());
		//addressIn.setAddressLine2(_address.getAddressLine2());
		addressIn.setAddressLine3(_address.getAddressLine3());
		addressIn.setAddress(_address.getAddressLine1());
		addressIn.setSuite(_address.getAddressLine2());
		addressIn.setCity(_address.getCity());
		addressIn.setState(_address.getState());
		addressIn.setPostalCode(_address.getZip9());
		addressIn.setCountryCode(_address.getCountryCode());
		ArrayOfAddressIn arrayOfAddressIn = new ArrayOfAddressIn();
		arrayOfAddressIn.getAddressIn().add(addressIn);   

		/*
		 * 6. Construct request object
		 *    
		 *    Note: you will need to RTI CLNVerify.java class
		 */
		CLNVerify req = new CLNVerify();
		req.setAddressCount(arrayOfAddressIn.getAddressIn().size());
		req.setAuthentication(authentication);
		req.setCampaignID("");
		req.setAddressesIn(arrayOfAddressIn);
		req.setParameters(parameters);

		/*
		 * 7. Instantiate and populate holders for user defined and
		 *    complex data types
		 */
		Holder<String> campaign_id = new Holder<String>(req.getCampaignID());
		Holder<Long> error_code = new Holder<Long>();
		Holder<String> error_message = new Holder<String>();
		Holder<Long> result_count = new Holder<Long>();
		Holder<ArrayOfAddressOut> array_of_address_out = new Holder<ArrayOfAddressOut>();

		/*
		 * 8. Invoke service operation 
		 * 
		 */
                try{
                    port.clnVerify(req.getAuthentication()
                                    , new Holder<String>( req.getCampaignID())
                                    , req.getParameters()
                                    , req.getAddressCount()
                                    , req.getAddressesIn()
                                    , error_code
                                    , error_message
                                    , result_count
                                    , array_of_address_out
                                            ); 
                } catch (Exception e){
                    e.printStackTrace();
                }

		/*
		 * 9. Process error codes, messages and results counts
		 * 
		 */

		ArrayOfAddressOut retval = array_of_address_out.value;
		List<AddressOut> addressOut_list = retval.getAddressOut();  
                
		/*
		 * 10. Process verified address response
		 * 
		 */
		for (AddressOut addressOut : addressOut_list) {
                        _address.setAddressLine1(nullToString(addressOut.getAddressLine1()));
                        //_address.setAddressLine2(nullToString(addressOut.getAddressLine2()));
                        _address.setAddressLine2(nullToString(addressOut.getSuite()));
                        _address.setAddressLine3(nullToString(addressOut.getAddressLine3()));
                        _address.setCity(nullToString(addressOut.getCity()));
                        _address.setState(nullToString(addressOut.getState()));
                        _address.setZip9(nullToString(addressOut.getPostalCodeFull()));
                        _address.setCountyName(nullToString(addressOut.getCountyName()));
                        _address.setCountryCode(nullToString(addressOut.getCountryCode())); 
                        _address.statusCode = addressOut.getStatusCode();
                        _address.errorCode  = nullToString(addressOut.getDPVErrorCode()).trim();	                                           
                        if (nullToString(addressOut.getDPVErrorCode()).trim().length() > 0){					
                          _address.errorString = " "+nullToString(addressOut.getDPVErrorCode())+" - "+addressOut.getErrorString();
                        }else{
                           _address.errorString = " "+nullToString(addressOut.getErrorString());	
                        }
		}
                return _address;		            
        }   
        
        /* Extracts each node's value, if error or no value, returns blank (not null) */
        private String NodeValue(Element elLists, String sTagName)
        {
            String sNodeValue = "";
            try {
                NodeList nlXml = elLists.getElementsByTagName(sTagName);
                Element elXml = (Element)nlXml.item(0);
                NodeList nlXmlValue = elXml.getChildNodes();
                if (((Node)nlXmlValue.item(0))!=null){
                  sNodeValue = ((Node)nlXmlValue.item(0)).getNodeValue().trim();   
                }
            } catch (Exception e){
                sNodeValue = "";
            }
            return sNodeValue;
        }
        
        /* Convert all null characters to string. why? Response doesn't like nulls */
	public String nullToString(String theString) {
		String returnString = "";
		if (theString != null) {
			returnString = theString;
		}
		return returnString;
	}
        
	/**
	 * Try connecting to service
	 * 
	 */	
        public void testConnection(){
            
            CLNVerify req = new CLNVerify();    	
            port.clnVerify(new Authentication(), 
                           new Holder<String>(""), 
                           req.getParameters(), 
                           req.getAddressCount(), 
                           req.getAddressesIn(),
                           new Holder<Long>(),
                           new Holder<String>(), 
                           new Holder<Long>(), 
                           new Holder<ArrayOfAddressOut>());            
        }        
        
}
