PROCEDURE Verify_Telephone IS
  -- Check for phone area code splits and check the distance from the phone area code to the zipcode
  -- NOTE: This procedure should be fired on WHEN-VALIDATE-ITEM on the telephone field
  phone			CLEAN_Address.Phone_Rec;
  fv_return_code         VARCHAR2(10);
  fv_return_description  VARCHAR2(500);
  ln_max_distance        NUMBER := 100;
BEGIN
  -- Only Verify if the trigger item is the same as the cursor item
  -- (ie. don't fire more than once for one update)
  if :system.trigger_item != :system.cursor_item then
    return;
  end if;

  -- leave if we don't have data
  if :ADDR.telephone_1 IS NULL then
  	:ADDR.telephone_status_code := NULL;
  	:ADDR.telephone_error_code := NULL;
  	return;
  end if;
  
  -- Assign the input telephone
 	phone.phone_number := :ADDR.telephone_1;
 	phone.postal_code  := :ADDR.postal_code;
 	phone.Phone_Number_Output_Format := '(999)999-9999';
 	
 	-- Check the phone
 	CLEAN_Address.Phone_Check_Silent(
  							phone
               ,fv_return_code
               ,fv_return_description
               );
  if fv_return_code IS NOT NULL then
    MESSAGE(fv_return_description);
    return;
  end if;

  -- Set the output fields
 	:ADDR.telephone_1           := phone.phone_number;
 	:ADDR.telephone_status_code := NULL;
 	:ADDR.telephone_error_code  := NULL;
 	:ADDR.telephone_distance    := phone.Phone_Distance;

  -- get the status code and description
  if phone.Phone_Check_Status_Code IS NOT NULL then
   	:ADDR.telephone_status_code := phone.Phone_Check_Status_Code||'-'||cln$lookup.get_phone_status(phone.Phone_Check_Status_Code);
  end if;
  if phone.Phone_Check_Error_Code IS NOT NULL then
   	:ADDR.telephone_error_code := phone.Phone_Check_Error_Code||'-'||cln$lookup.get_phone_error(phone.Phone_Check_Error_Code);
  end if;

 	--
 	-- Check for Phone area code split
 	--
 	if phone.Phone_Check_Status_Code = 'U' then
 		:ADDR.telephone_1 := phone.new_phone_number;
		WARNING('Phone number updated due to area code split:'
		       ||chr(10)||'OLD: '||phone.phone_number
		       ||chr(10)||'NEW: '||phone.new_phone_number
		       );
 	--
	-- Check for a valid distancer from the Phone area code to the zipcode
 	--
 	elsif NVL(phone.Phone_Distance, -1) > NVL(ln_max_distance, 0)
 		    and NVL(phone.Phone_Distance, -1) != 9999 then
 		WARNING('WARNING: The Distance from the Area Code to the Postal Code ('||to_char(phone.Phone_Distance)
 		        ||' miles) exceeds the threshhold of '||to_char(ln_max_distance)||' miles!'
 		        ||chr(10)||'Suggested Area Code: '||phone.new_phone_area_code);
 	elsif phone.Phone_Check_Status_Code = 'C' then
 		WARNING('WARNING: A corrected Area Code is suggested based on the zip code entered.'
 		        ||chr(10)||'Suggested Area Code: '||phone.new_phone_area_code);
	elsif phone.Phone_Check_Status_Code IS NOT NULL
	      or phone.Phone_Check_Error_Code IS NOT NULL
	      then
 		WARNING('Check Phone Number'
 		         ||chr(10)||'Status: '||cln$lookup.Get_Phone_Status(phone.Phone_Check_Status_Code)
 		         ||chr(10)||'Error: '||cln$lookup.Get_Phone_Error(phone.Phone_Check_Error_Code)
 		         );
	end if;
	
  set_item_property('ADDR.TELEPHONE_1',   ITEM_IS_VALID, PROPERTY_TRUE);	
END;
