﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
/*
 *   GENERATING A PROXY FOR .NET ( Change directories to match your system's directory structure )
 *  ---------------------------------------------------------------------------------------------------------------------------
 *  - You will need to have the .NET SDK installed and a copy of Microsoft Visual Studio.
 *    This solution was developed with Visual Studio 2012 Professional.
 * 
 *  - Modify the distribution CLEAN_Address.wsdl found in the distribution media
 *    Copy the CLEAN_Address.wsdl file found in the CLEAN_Address installation to your build location.
 *    Edit the new file, in the <s:complexType name="Parameters"> section, change all type="s:boolean"  to type="s:string"
 *    
 *  - Create the proxy class
 *  "C:\Program Files\Microsoft SDKs\Windows\v7.0\Bin\x64\wsdl" /l:CS /protocol:SOAP C:\CleanAddress_x64\bin\CLEAN_Address.wsdl
 *  
 *  - Modify the proxy class CLNBatch.cs, changing the  url to match your target host and port
 * 
 *   public CLNBatch() {
 *       this.Url = "http://webservice.clean-address.com/CLNVerify";
 *   }
 *   
 *   /// Send parameters for socket (Protocol, Host, and Port)
 *   /// Protocol defaults to http, host defaults to localhost, and port defaults to 8097
 *   public CLNBatch(string Protocol, string Host, string Port) {
 *		this.Url = Protocol+"://"+Host+":"+Port+"/CLNVerify";
 *   }
 *
 *  - Create a DLL from the proxy class
 *  C:\Windows\Microsoft.NET\Framework64\v4.0.30319\csc /t:library /r:System.Web.Services.dll /r:System.Xml.dll CLNBatch.cs
 *
 *  - Using Microsoft Visual Studio, Create a Test client
 *  
 *  - Test the client
 *  "C:\ASP .NET Projects\clnaddrws\Client\Client\bin\Debug\client.exe"
 * 
 *  - Sample Response
 *  
 * C:\ASP .NET Projects\clnaddrws\Client\Client\bin\Debug>client
 *
 * Proxy Request Return Code: 0
 *
 *            Address Line 1: 6530 W Rogers Circle
 *            Address Line 2:
 *            Address Line 3:
 *                      City: Boca Raton
 *                    County: Palm Beach
 *                     State: FL
 *           Zip/Postal Code: 33487-2753
 *                   Country: United States
 *
 *             Error Message:
 *              Error String: Suite/Apt Missing
 *                DPV Status: N1
 *           Suggestion List: Company:Number:Pre Dir:Street:Suffix:Post Dir:Suite;:6530:W:Rogers:Cir::;:6530:W:Rogers:Cir::Ste [28-33]
 * 
 * - Once the proxy and sample client are confirmed functional, modify to meet your internal and project needs
 * 
 *  KNOW ISSUES:
 *  
 *     - parameter values not showing in the XML request, you will need to ensure the parameters section in the .wsdl 
 *       is modified as noted above, i.e,  before generating .cs file in the <s:complexType name="Parameters"> section
 *       ,change all type="s:boolean", and type="s:int"  to type="s:string"
 * 
 */
namespace TestClnaddrwsServer
{
    public class Client
    {

        static String Protocol = "http";
        static String Host     = "localhost";
        static String Port     = "8097";

        public Client() {}

        public static void Main(string[] args)
        {

            //Instantiate the proxy
            CLNBatch server = new CLNBatch(Protocol,Host,Port);
            string       campaignID="test";
            long         addressCount=1;
            string       errorMessage="";
            long         resultCount=0;
            long         returnCode=0;

            Authentication authentication = new Authentication();
            authentication.CustomerID = 1;
            authentication.DepartmentID = 0;
            authentication.Password = "password";

            Parameters     parametersIn = new Parameters();         
            parametersIn.VerifyAddress = "true";
            parametersIn.GeoCodeAddress = "true";
            parametersIn.CheckTelephone = "true";
            parametersIn.ParseName = "true";
            parametersIn.ParseEmail = "false";
            parametersIn.DNSCheckEmail = "false";
            parametersIn.UseGenericAddressLines = "true";
            parametersIn.GenericAddressLines ="3";
            parametersIn.FullNameInAddress = "false";
            parametersIn.CompanyNameInAddress = "false";
            parametersIn.OutputAddressWithCompanyNameAttention = "false";
            parametersIn.CountryReturnType = CountryReturnType.ISO_3 ;
            parametersIn.PreferredLanguage = PreferredLanguageType.ENGLISH;
            parametersIn.ErrorSuggestCount = "10";
            parametersIn.VerboseSuggestList = "true";
            parametersIn.IncludeSuggestHeader = "true";
            parametersIn.MaxCityLength = "30";
            parametersIn.MaxProvinceLength = "30";
            parametersIn.MaxAddressLineLength = "40";
            parametersIn.ExpandStreetSuffix = "true";
            parametersIn.ExpandSingleDirectional = "false";
            parametersIn.ExpandDoubleDirectional = "false";
            parametersIn.SuiteLineBeforeStreet = "false";
            parametersIn.AppendSuiteToStreet = "true";
            parametersIn.AlwaysStandardize = "true";
            parametersIn.AlwaysUpperCase = "false";
            parametersIn.BasicAddressSearch = "false";
            parametersIn.PhoneNumberOutputFormat = "0";           
            AddressIn[]    addressInArray = new AddressIn[1];
            AddressIn      addressIn      = new AddressIn();
            addressIn.AddressLine1 = "6530 w rogers";
            addressIn.AddressLine2 = "";
            addressIn.City = "boca raton";
            addressIn.State = "fl";
            addressIn.PostalCode = "";
            addressIn.CountryCode = "USA";
            addressIn.CountryName = "United States";
            addressInArray[0] = addressIn;

            AddressOut[]   addressOutArray; 
            
            try
            {
                returnCode = server.CLNVerify(authentication, ref campaignID, parametersIn, addressCount, addressInArray, out errorMessage, out resultCount, out addressOutArray);
            }
            catch (Exception ex)
            {
                Console.WriteLine(" ");
                Console.WriteLine(ex.Message );
                Console.WriteLine("Protocol=" + Protocol + ", Host=" + Host + ", Port=" + Port);
                Console.WriteLine(" ");
                return;
            }

            // Display response
            Console.WriteLine("CLEAN_Address - .NET sample");
            Console.WriteLine("");
            Console.WriteLine("\n Proxy Request Return Code: " + returnCode);
            Console.WriteLine("");
            Console.WriteLine("            Address Line 1: " + addressOutArray[0].AddressLine1);
            Console.WriteLine("            Address Line 2: " + addressOutArray[0].AddressLine2);
            Console.WriteLine("            Address Line 3: " + addressOutArray[0].AddressLine3);
            Console.WriteLine("                      City: " + addressOutArray[0].City);
            Console.WriteLine("                    County: " + addressOutArray[0].CountyName);
            Console.WriteLine("                     State: " + addressOutArray[0].State);
            Console.WriteLine("           Zip/Postal Code: " + addressOutArray[0].PostalCodeFull);
            Console.WriteLine("                   Country: " + addressOutArray[0].CountryName);
            Console.WriteLine("");
            Console.WriteLine("             Error Message: " + errorMessage);
            Console.WriteLine("              Error String: " + addressOutArray[0].ErrorString);
            Console.WriteLine("                DPV Status: " + addressOutArray[0].DPVErrorCode);
            Console.WriteLine("           Suggestion List: " + addressOutArray[0].SuggestionList);
        }
    }
}
