/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMManifest
extends DOMStructure
implements Manifest {
    private final List references;
    private final String id;

    public DOMManifest(List list, String string2) {
        if (list == null) {
            throw new NullPointerException("references cannot be null");
        }
        ArrayList arrayList = new ArrayList(list);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof Reference) continue;
            throw new ClassCastException("references[" + i + "] is not a valid type");
        }
        this.references = Collections.unmodifiableList(arrayList);
        this.id = string2;
    }

    public DOMManifest(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(element, "Id");
        Element element2 = DOMUtils.getFirstChildElement(element);
        ArrayList<DOMReference> arrayList = new ArrayList<DOMReference>();
        while (element2 != null) {
            arrayList.add(new DOMReference(element2, xMLCryptoContext, provider));
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.references = Collections.unmodifiableList(arrayList);
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public void marshal(Node node, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "Manifest", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttributeID(element, "Id", this.id);
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            DOMReference dOMReference = (DOMReference)this.references.get(i);
            dOMReference.marshal(element, string2, dOMCryptoContext);
        }
        node.appendChild(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Manifest)) {
            return false;
        }
        Manifest manifest = (Manifest)object;
        boolean bl = this.id == null ? manifest.getId() == null : this.id.equals(manifest.getId());
        return bl && ((Object)this.references).equals(manifest.getReferences());
    }
}

